/*
Demo code re-purposed from 
http://docs.oracle.com/javase/tutorial/uiswing/events/mousemotionlistener.html
*/

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseEvent;
import java.awt.GridLayout;
import javax.swing.*;

public class MME_Demo extends JPanel implements MouseMotionListener{

	Area A;
	JTextArea TA;
	static final String NEWLINE = System.getProperty("line.separator");
	
	public static void main(String[] args){
		
		try{
			UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
		}	
		catch (UnsupportedLookAndFeelException ex) {
            ex.printStackTrace();
        }
		catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
		catch (InstantiationException ex) {
            ex.printStackTrace();
        }
		catch (ClassNotFoundException ex) {
            ex.printStackTrace();
		}
		
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run(){
				createAndShowGUI();
			}
		});
	}
	
	private static void createAndShowGUI(){
		
		JFrame frame = new JFrame("MouseMotionEventDemo");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		JComponent newContentPane = new MME_Demo();
		newContentPane.setOpaque(true);
		frame.setContentPane(newContentPane);
		
		frame.pack();
		frame.setVisible(true);
		
	}
	
	public MME_Demo(){
		
		super(new GridLayout(0,1));
		A = new Area(Color.BLUE);
		add(A);
		
		TA = new JTextArea();
		TA.setEditable(false);
		JScrollPane scrollPane = new JScrollPane(TA,
				JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
				JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		scrollPane.setPreferredSize(new Dimension(200, 100));
		
		add(scrollPane);
	
		A.addMouseMotionListener(this);
		addMouseMotionListener(this);
		
		setPreferredSize(new Dimension(500, 500));
		setBorder(BorderFactory.createEmptyBorder(20,20,20,20));
		
	}
	
	void eventOutput(String eventDescription, MouseEvent e){
		
		TA.append(eventDescription
				+ " (" + e.getX() + "," + e.getY() + ") "
				+ " detected on "
				
				+ e.getComponent().getClass().getName()
				
				+NEWLINE);
		TA.setCaretPosition(TA.getDocument().getLength());
		
	}
	
	public void mouseMoved(MouseEvent e){
		
		eventOutput(" Mouse moved", e);
		
	}
	
	public void mouseDragged(MouseEvent e){
		
		eventOutput(" Mouse dragged", e);
		
	}
}
